<!-- FONT AWESOME -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<!-- SIDEBAR STYLE -->
<style>
.sidebar{
    width:260px;height:100vh;position:fixed;left:0;top:0;
    background:linear-gradient(180deg,#0d6efd,#053089,#021e52);
    color:#fff;padding:15px 10px;overflow-y:auto;
}
.sidebar a{color:#fff;text-decoration:none;}
.sidebar-menu-item{
    padding:10px 15px;border-radius:8px;cursor:pointer;
    display:flex;align-items:center;user-select:none;
}
.sidebar-menu-item:hover{background:rgba(255,255,255,0.15);}
.sidebar-menu-item i{margin-right:10px;width:20px;}
.sidebar-title{font-size:14px;margin:12px;font-weight:600;opacity:.85;}
.collapse a{padding-left:40px!important;}
.arrow{transition:.3s;}
.rotate{transform:rotate(90deg);}
.active-menu{background:rgba(255,255,255,0.20);}
</style>

<aside class="sidebar">

    <!-- LOGO -->
    <div class="text-center mb-3">
        <img src="<?php echo MENU_PATH; ?>images/hospital_logo.png" class="rounded-circle" width="85">
        <div class="mt-2 fw-bold"><?= $_SESSION['hospital_name'] ?? "Hospital Name"; ?></div>
    </div>

    <hr class="text-light opacity-25">

    <!-- NAVIGATION -->
    <div class="sidebar-title">Navigation</div>
    <a href="<?php echo MENU_PATH; ?>hospital_dashboard.php" class="sidebar-menu-item">
        <i class="fa-solid fa-home"></i> Dashboard
    </a>

    <!-- Attendance -->
    <div class="sidebar-title">Attendance</div>
    <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#attMenu">
        <i class="fa-solid fa-calendar-check"></i> Attendance
        <i class="fa-solid fa-angle-right ms-auto arrow"></i>
    </div>
    <div class="collapse" id="attMenu" data-bs-parent=".sidebar">
        <a href="<?php echo MENU_PATH; ?>attendance/take_attendance.php" class="sidebar-menu-item">✔ Take Attendance</a>
        <a href="<?php echo MENU_PATH; ?>attendance/view_attendance.php" class="sidebar-menu-item">👁 View Attendance</a>
        <a href="<?php echo MENU_PATH; ?>attendance/monthly_report.php" class="sidebar-menu-item">📊 Monthly Report</a>
    </div>

    <!-- Doctors -->
    <div class="sidebar-title">Doctor Management</div>
    <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#docMenu">
        <i class="fa-solid fa-user-doctor"></i> Doctors
        <i class="fa-solid fa-angle-right ms-auto arrow"></i>
    </div>

    <div class="collapse" id="docMenu" data-bs-parent=".sidebar">

        <a href="<?php echo MENU_PATH; ?>doctor/add.php" class="sidebar-menu-item">➕ Add Doctor</a>
        <a href="<?php echo MENU_PATH; ?>doctor/view_doctor_list.php" class="sidebar-menu-item">📋 Doctor List</a>

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#docSpecialization">
            <i class="fa-solid fa-calendar"></i> Specializations
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="docSpecialization" data-bs-parent="#docMenu">
            <a href="<?php echo MENU_PATH; ?>doctor/specialization/add_specialization.php" class="sidebar-menu-item">➕ Add Specialization</a>
            <a href="<?php echo MENU_PATH; ?>doctor/specialization/view_specialization.php" class="sidebar-menu-item">👁 View Specialization</a>
        </div>

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#docSchedule">
            <i class="fa-solid fa-calendar-days"></i> Schedule
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="docSchedule" data-bs-parent="#docMenu">
            <a href="<?php echo MENU_PATH; ?>doctor/schedule/add_schedule.php" class="sidebar-menu-item">➕ Add Schedule</a>
            <a href="<?php echo MENU_PATH; ?>doctor/schedule/view_doctor_schedule.php" class="sidebar-menu-item">👁 View Schedule</a>
        </div>
    </div>

    <!-- MASTER SETUP -->
    <div class="sidebar-title">Master Setup</div>
    <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#masterMenu">
        <i class="fa-solid fa-gears"></i> Master Setup
        <i class="fa-solid fa-angle-right ms-auto arrow"></i>
    </div>

    <div class="collapse" id="masterMenu" data-bs-parent=".sidebar">

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#staffMenu">
            <i class="fa-solid fa-users"></i> Staff
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="staffMenu" data-bs-parent="#masterMenu">
            <a href="<?php echo MENU_PATH; ?>master_setup/staff/add_staff.php" class="sidebar-menu-item">➕ Add Staff</a>
            <a href="<?php echo MENU_PATH; ?>master_setup/staff/view_staff_list.php" class="sidebar-menu-item">📋 Staff List</a>
            <a href="<?php echo MENU_PATH; ?>master_setup/staff/Suspended/suspend_staff_list.php" class="sidebar-menu-item">⛔ Suspended List</a>
        </div>

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#deptMenu">
            <i class="fa-solid fa-building"></i> Department
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="deptMenu" data-bs-parent="#masterMenu">
            <a href="<?php echo MENU_PATH; ?>master_setup/department/add_department.php" class="sidebar-menu-item">➕ Add Department</a>
        </div>

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#wardMenu">
            <i class="fa-solid fa-door-open"></i> Ward
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="wardMenu" data-bs-parent="#masterMenu">
            <a href="<?php echo MENU_PATH; ?>master_setup/ward/add_ward.php" class="sidebar-menu-item">➕ Add Ward</a>
            <a href="<?php echo MENU_PATH; ?>master_setup/ward/view_ward.php" class="sidebar-menu-item">📋 Ward List</a>
        </div>

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#bedMenu">
            <i class="fa-solid fa-bed"></i> Bed
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="bedMenu" data-bs-parent="#masterMenu">
            <a href="<?php echo MENU_PATH; ?>master_setup/bed/beds.php" class="sidebar-menu-item">➕ Add Bed</a>
        </div>

    </div>

    <!-- SETTINGS -->
    <div class="sidebar-title">Settings</div>
    <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#setMenu">
        <i class="fa-solid fa-gear"></i> Settings
        <i class="fa-solid fa-angle-right ms-auto arrow"></i>
    </div>

    <div class="collapse" id="setMenu" data-bs-parent=".sidebar">
        <a href="<?php echo MENU_PATH; ?>setting/system_setting.php" class="sidebar-menu-item">⚙ System Settings</a>

        <div class="sidebar-menu-item" data-bs-toggle="collapse" data-bs-target="#deviceMenu">
            <i class="fa-solid fa-microchip"></i> Device Settings
            <i class="fa-solid fa-angle-right ms-auto arrow"></i>
        </div>
        <div class="collapse" id="deviceMenu" data-bs-parent="#setMenu">
            <a href="<?php echo MENU_PATH; ?>attendance/biometrics/add_devices.php" class="sidebar-menu-item">➕ Add Device</a>
            <a href="<?php echo MENU_PATH; ?>attendance/biometrics/view_devices.php" class="sidebar-menu-item">📋 Devices List</a>
        </div>
    </div>

</aside>


<!-- Bootstrap JS -->
<!-- BOOTSTRAP JS (MANDATORY single load only) -->

<script>
document.querySelectorAll("[data-bs-toggle='collapse']").forEach(item=>{
    item.addEventListener("click",function(e){
        e.preventDefault();
        const target = document.querySelector(this.getAttribute("data-bs-target"));
        const obj = bootstrap.Collapse.getOrCreateInstance(target);
        obj.toggle(); // <-- Main click fix
    });
});

document.querySelectorAll(".collapse").forEach(parent=>{
    parent.addEventListener("hide.bs.collapse",()=>{
        parent.querySelectorAll(".collapse.show").forEach(child=>{
            bootstrap.Collapse.getOrCreateInstance(child).hide();
        });
    });
});

document.querySelectorAll("[data-bs-toggle='collapse']").forEach(el=>{
    const arrow = el.querySelector(".arrow");
    if(!arrow) return;
    const target=document.querySelector(el.dataset.bsTarget);
    target.addEventListener("shown.bs.collapse",()=>arrow.classList.add("rotate"));
    target.addEventListener("hidden.bs.collapse",()=>arrow.classList.remove("rotate"));
});
</script>
